/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.client.particle.SAO;

import com.dfdyz.epicacg.client.render.EpicACGRenderType;
import com.dfdyz.epicacg.utils.RenderUtils;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.client.model.ItemSkin;
import yesman.epicfight.api.client.model.ItemSkins;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class PhotonTrailingParticle
extends NoRenderParticle {
    private final Joint joint;
    private final TrailInfo trailInfo;
    private final StaticAnimation animation;
    private final LivingEntityPatch<?> entitypatch;
    private boolean animationEnd = false;

    public PhotonTrailingParticle(ClientLevel level, LivingEntityPatch<?> entitypatch, Joint joint, StaticAnimation animation, TrailInfo trailInfo) {
        super(level, 0.0, 0.0, 0.0);
        this.joint = joint;
        this.entitypatch = entitypatch;
        this.animation = animation;
        this.f_107219_ = false;
        this.trailInfo = trailInfo;
        this.f_107225_ = trailInfo.trailLifetime;
        if (((LivingEntity)this.entitypatch.getOriginal()).m_6084_()) {
            Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
            this.m_107264_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public void m_5989_() {
        AnimationPlayer animPlayer = this.entitypatch.getAnimator().getPlayerFor((DynamicAnimation)this.animation);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.animationEnd) {
            if (this.f_107225_-- <= 0) {
                this.m_107274_();
            }
        } else if (!((LivingEntity)this.entitypatch.getOriginal()).m_6084_() || this.animation != animPlayer.getAnimation().getRealAnimation() || animPlayer.getElapsedTime() > this.trailInfo.endTime) {
            this.animationEnd = true;
            this.f_107225_ = this.trailInfo.trailLifetime;
        }
        if (((LivingEntity)this.entitypatch.getOriginal()).m_6084_() && this.f_107225_ > 0 && animPlayer.getElapsedTime() > this.trailInfo.startTime) {
            Vec3 old = ((LivingEntity)this.entitypatch.getOriginal()).m_20318_(0.0f);
            Vec3 curr = ((LivingEntity)this.entitypatch.getOriginal()).m_20318_(1.0f);
            int count = Math.max((int)(curr.m_82554_(old) / 0.17), 2);
            float per = 1.0f / (float)count;
            for (int i = 0; i < count; ++i) {
                Vec3 pos = curr.m_165921_(old, (double)(per * (float)i));
                Photon photon = new Photon(this.f_107208_, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.trailInfo.trailLifetime, this.trailInfo.rCol, this.trailInfo.gCol, this.trailInfo.bCol);
                photon.m_6569_(25.0f);
                RenderUtils.AddParticle(this.f_107208_, photon);
            }
            this.m_107264_(curr.f_82479_, curr.f_82480_, curr.f_82481_);
        }
    }

    public static class Photon
    extends Particle {
        float oAlpha;
        ResourceLocation texture = RenderUtils.GetTexture("particle/photo");

        protected Photon(ClientLevel level, double x, double y, double z, int lifetime, float r, float g, float b) {
            super(level, x, y, z);
            this.f_107225_ = lifetime;
            this.f_107226_ = 0.0f;
            this.f_107219_ = false;
            this.f_107227_ = r;
            this.f_107228_ = g;
            this.f_107229_ = b;
            this.oAlpha = this.f_107230_ = 1.0f;
        }

        private float getAlpha(float pt) {
            return Mth.m_14179_((float)pt, (float)this.oAlpha, (float)this.f_107230_);
        }

        public boolean shouldCull() {
            return false;
        }

        public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float pt) {
            float alp = this.getAlpha(pt);
            float t_ = ((float)(this.f_107224_ % 10) + pt) / 9.0f;
            t_ = t_ <= 0.5f ? 4.0f * t_ - 1.0f : -4.0f * t_ + 3.0f;
            float sz = (0.5f + 0.1f * t_) * alp * Mth.m_14116_((float)(this.f_107221_ * this.f_107222_));
            RenderUtils.RenderQuadFaceOnCamera(vertexConsumer, camera, (float)Mth.m_14139_((double)pt, (double)this.f_107209_, (double)this.f_107212_), (float)Mth.m_14139_((double)pt, (double)this.f_107210_, (double)this.f_107213_), (float)Mth.m_14139_((double)pt, (double)this.f_107211_, (double)this.f_107214_), this.f_107227_, this.f_107228_, this.f_107229_, alp, sz, pt);
        }

        public void m_5989_() {
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            this.oAlpha = this.f_107230_;
            if (this.f_107224_++ >= this.f_107225_) {
                this.m_107274_();
            }
            this.f_107230_ = 1.0f * (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_;
        }

        public ParticleRenderType m_7556_() {
            return EpicACGRenderType.getBloomRenderTypeByTexture(this.texture);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet spriteSet) {
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            int eid = (int)Double.doubleToRawLongBits(x);
            int animid = (int)Double.doubleToRawLongBits(z);
            int jointId = (int)Double.doubleToRawLongBits(xSpeed);
            int idx = (int)Double.doubleToRawLongBits(ySpeed);
            Entity entity = level.m_6815_(eid);
            if (entity != null) {
                ItemStack stack;
                ItemSkin itemSkin;
                LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
                StaticAnimation animation = AnimationManager.getInstance().byId(animid);
                Optional trailInfo = animation.getProperty((AnimationProperty)ClientAnimationProperties.TRAIL_EFFECT);
                TrailInfo result = (TrailInfo)((List)trailInfo.get()).get(idx);
                if (result.hand != null && (itemSkin = ItemSkins.getItemSkin((Item)(stack = ((LivingEntity)entitypatch.getOriginal()).m_21120_(result.hand)).m_41720_())) != null) {
                    result = itemSkin.trailInfo().overwrite(result);
                }
                if (entitypatch != null && animation != null && trailInfo.isPresent()) {
                    return new PhotonTrailingParticle(level, entitypatch, entitypatch.getArmature().searchJointById(jointId), animation, result);
                }
            }
            return null;
        }
    }
}

